<?php

use Zotlabs\Extend\Hook;
use Zotlabs\Extend\Route;
use Zotlabs\Lib\Apps;

/**
 * Name: Bandcamp Plugin
 * Description: Embed Bandcamp albums (Select wordpress embed)
 * Version: 1.0
 * Author: Waitman Gobble <waitman@zap.dog>
 * Maintainer: Waitman Gobble <waitman@zap.dog> 
 */

function bandcamp_install() {
	Hook::register('prepare_body', 'addon/bandcamp/bandcamp.php', 'bandcamp_prepare_body', 1, 10);
}


function bandcamp_uninstall() {
	Hook::unregister('prepare_body', 'addon/bandcamp/bandcamp.php', 'bandcamp_prepare_body', 1, 10);
}

function bandcamp_prepare_body(&$b) {

	if (strstr($b['html'],'[bandcamp'))
	{
		$html = str_replace('[/bandcamp]','',$b['html']);
		$bch = explode('[bandcamp',$html);
		$html = array_shift($bch);
		
		foreach ($bch as $v)
		{
			$xx = explode(']',$v);
			$bc = array_shift($xx);
			$ax = explode('album=',$bc);
			$xa = explode(' ',array_pop($ax));
			$album = array_shift($xa);

			if (strstr($bc,'track='))
			 {
   			$ax = explode('track=',$bc);
   			$xa = explode(' ',array_pop($ax));
   			$track = array_shift($xa);

			   $html.='<iframe style="border:0;width:350px;max-width:100%;height:470px;" src="https://bandcamp.com/EmbeddedPlayer/album='.$album.'/size=large/bgcol=ffffff/linkcol=0687f5/tracklist=false/transparent=true/track='.$track.'/" seamless></iframe>';
 			} else {
   			$html.='<iframe style="border:0;width:350px;max-width:100%;height:470px;" src="https://bandcamp.com/EmbeddedPlayer/album='.$album.'/size=large/bgcol=ffffff/linkcol=0687f5/tracklist=false/transparent=true/" seamless></iframe>';
			 }
			$html.=join(']',$xx);
		}
		$b['html']=$html;
	}

}


